<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;
use App\Http\ClearsResponseCache;
use BeyondCode\Comments\Traits\HasComments;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\DB;

class Anime extends Model
{

  use Favoriteable,ClearsResponseCache,HasComments;



    protected $fillable = ['tmdb_id', 'name', 'overview', 'poster_path', 'backdrop_path',
    'preview_path', 'vote_average', 'vote_count', 'popularity', 'premuim','active','views',
     'featured', 'first_air_date', 'tv','pinned','newEpisodes','imdb_external_id','original_name','trailer_url','subtitle','rating'];

     protected $with = ['casters.cast','genres.genre', 'seasons','networks.network','spoken_languages'];

     protected $appends = ['genreslist','casterslist','relateds'];

    protected $casts = [
        'status' => 'int',
        'premuim' => 'int',
        'active' => 'int',
        'featured' => 'int',
        'pinned' => 'int',
        'newEpisodes' => 'int'
    ];


    public function networks()
    {
        return $this->hasMany('App\AnimeNetwork');
    }

    public function casters()
    {
        return $this->hasMany('App\AnimeCast');
    }

    public function spoken_languages()
    {
        return $this->hasMany('App\AnimeSpokenLanguage');
    }


    public function genres()
    {
        return $this->hasMany('App\AnimeGenre');
    }

    public function seasons()
    {
        return $this->hasMany('App\AnimeSeason')->orderBy('season_number');
    }



    public function getCasterslistAttribute(): array
    {
        $casters = [];
        foreach ($this->casters as $caster) {
            $casters[] = $caster->cast;
        }
        return $casters;
    }


    public function getGenreslistAttribute()
    {
        $genres = [];
        foreach ($this->genres as $genre) {
            $genres[] = $genre['name'];
        }
        return $genres;
    }


    public function relatedsAnimes()
    {


        $selectAnime = [
            'animes.id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
                        'pinned', 'animes.created_at','animes.updated_at', 'views', DB::raw("'anime' AS type"),"newEpisodes"
        ];

        $moviesGenre = $this->withOnly('genres.genre')
            ->where('id', $this->id)
            ->select(['animes.id', 'name', 'poster_path', 'vote_average', 'newEpisodes', 'subtitle'])
            ->where('active', 1)
            ->limit(1)
            ->orderByDesc('animes.created_at')
            ->get();

        $relatedAnimes = [];

        foreach ($moviesGenre as $anime) {
            $genre = $anime->genres[0]->genre_id;

            $relatedAnimesQuery = DB::table('animes')
                ->join('anime_genres', 'animes.id', '=', 'anime_genres.anime_id')
                ->where('anime_genres.genre_id', $genre)
                ->where('anime_genres.anime_id', '!=', $anime->id)
                ->select($selectAnime)
                ->where('active', 1)
                ->limit(10)
                ->orderByDesc('animes.created_at')
                ->get();

            $relatedAnimes = $relatedAnimesQuery->toArray();
        }

        return $relatedAnimes;
    }


    public function getRelatedsAttribute()
    {
        // Implement logic to retrieve related movies
        // Example:
        return $this->relatedsAnimes();
    }
}
