<?php

namespace App\Http\Controllers;

use App\Certification;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class CertificationController extends Controller
{
    


    public function data()
    {
        return response()->json(Certification::paginate(12), 200);
    }


    public function datacertifications()
    {
        return response()->json(Certification::get(), 200);
    }

   
    public function fetch(Request $request)
    {


        foreach ($request->certifications as $countryCode => $countryCertifications) {
            // Use $countryCode as the object name (e.g., "AU" for Australia)
            foreach ($countryCertifications as $certification) {

                if (!Certification::where('country_code', $countryCode)->exists()
                
                && !Certification::where('certification', $certification['certification'])->exists()) {


                Certification::create([
                    'country_code' => $countryCode,
                    'certification' => $certification['certification'],
                    'meaning' => $certification['meaning'],
                    'order' => $certification['order'],
                ]);

                

            }
            }
        }



        return response()->json(['message' => 'Data inserted successfully']);
    }


}
