<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Illuminate\Http\Request;

class VidSrcExtractorController {
    public function hunter_def($d, $e, $f) {
        $g = str_split("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+/");
        $h = array_slice($g, 0, $e);
        $i = array_slice($g, 0, $f);
        $d = array_reverse(str_split($d));
        $j = 0;
        foreach ($d as $c => $b) {
            if (in_array($b, $h)) {
                $j = $j + array_search($b, $h) * pow($e, $c);
            }
        }
        $k = "";
        while ($j > 0) {
            $k = $i[$j % $f] . $k;
            $j = ($j - ($j % $f)) / $f;
        }
        return intval($k) ?: 0;
    }

    public function hunter($h, $u, $n, $t, $e, $r) {
        $r = "";
        $i = 0;
        while ($i < strlen($h)) {
            $j = 0;
            $s = "";
            while ($h[$i] !== $n[$e]) {
                $s .= $h[$i];
                $i = $i + 1;
            }
            while ($j < strlen($n)) {
                $s = str_replace($n[$j], strval($j), $s);
                $j = $j + 1;
            }
            $r .= chr($this->hunter_def($s, $e, 10) - $t);
            $i = $i + 1;
        }
        return $r;
    }

    public function decode_src($encoded, $seed) {
        $encoded_buffer = hex2bin($encoded);
        $decoded = "";
        for ($i = 0; $i < strlen($encoded_buffer); $i++) {
            $decoded .= chr(ord($encoded_buffer[$i]) ^ ord($seed[$i % strlen($seed)]));
        }
        return $decoded;
    }

    public function decode_base64_url_safe($s) {
        $standardized_input = str_replace('_', '/', str_replace('-', '+', $s));
        $binary_data = base64_decode($standardized_input);
        return new \SplFixedArray($binary_data);
    }

    public function handle_vidsrc_stream($url, $source) {
        $max_retries = 50;
        $attempt = 0;
        while ($attempt < $max_retries) {
            try {
                $client = new Client(['verify' => false]);
                $req = $client->get($url, [
                    'headers' => [
                        'Referer' => $source
                    ]
                ]);
                $body = $req->getBody();
                $req_text = $body->getContents();
                $hls_url_match = [];
                preg_match('/file:"([^"]*)"/', $req_text, $hls_url_match);
                if ($hls_url_match) {
                    $hls_url = $hls_url_match[1];
                    $hls_url = preg_replace('/\/\/\S+?=/', '', $hls_url);
                    try {
                        $hls_url = base64_decode($hls_url);
                        $hls_url = utf8_decode($hls_url);
                    } catch (Exception $e) {
                        $attempt += 1;
                        continue;
                    }
                    if (substr($hls_url, -10) === "/list.m3u8") {
                        $set_pass_match = [];
                        preg_match('/var pass_path = "(.*?)";/', $req_text, $set_pass_match);
                        if ($set_pass_match && substr($set_pass_match[1], 0, 2) === "//") {
                            $set_pass = "https:" . $set_pass_match[1];
                            $client->get($set_pass, [
                                'headers' => [
                                    'Referer' => $source
                                ]
                            ]);
                        }
                        return $hls_url;
                    }
                }
                echo "URL match not found or incomplete URL in response, retrying...\n";
                $attempt += 1;
            } catch (Exception $e) {
                echo "Request failed: " . $e->getMessage() . "\n";
                $attempt += 1;
            }
        }
        echo "Maximum retries reached, unable to retrieve full URL.\n";
        return null;
    }

    public function handle_2embed($url, $source) {
        
        // TODO: Implement handle_2embed
    }

    public function handle_multiembed($url, $source) {
        $client = new Client(['verify' => false]);
        $req = $client->get($url, [
            'headers' => [
                'Referer' => $source
            ]
        ]);
        $req_text = $req->getBody()->getContents();
        $matches = [];
        preg_match('/escape\(r\)\)}\((.*?)\)/', $req_text, $matches);
        $processed_values = [];
        if (!$matches) {
            echo "[Error] Failed to fetch multiembed, this is likely because of a captcha, try accessing the source below directly and solving the captcha before re-trying.\n";
            echo $url . "\n";
            return null;
        }
        foreach (explode(',', $matches[1]) as $val) {
            $val = trim($val);
            if (is_numeric($val) || (substr($val, 0, 1) === '-' && is_numeric(substr($val, 1)))) {
                $processed_values[] = intval($val);
            } elseif (substr($val, 0, 1) === '"' && substr($val, -1) === '"') {
                $processed_values[] = substr($val, 1, -1);
            }
        }
        $unpacked = $this->hunter(...$processed_values);
        $hls_url_match = [];
        preg_match('/file:"([^"]*)"/', $unpacked, $hls_url_match);
        $hls_url = $hls_url_match[1];
        return $hls_url;
    }


    public function get_vidsrc_stream($name, $media_type, $code, $language, $season = null, $episode = null) {
        $provider = strpos($code, "tt") !== false ? "imdb" : "tmdb";
        $url = "https://vidsrc.me/embed/$media_type?$provider=$code";
        if ($season && $episode) {
            $url .= "&season=$season&episode=$episode";
        }
       
        $client = new Client(['verify' => false]);
        $req = $client->get($url);
        $req_text = $req->getBody()->getContents();
        $crawler = new Crawler($req_text);
        $sources = [];
        $crawler->filter('div.server')->each(function (Crawler $attr) use (&$sources) {
            $sources[$attr->text()] = $attr->attr('data-hash');
        });
        $source = $sources[$name] ?? null;
        if (!$source) {
            echo "No source found for $name, available sources: " . implode(", ", array_keys($sources)) . "\n";
            return null;
        }
        $req_1 = $client->get("https://rcp.vidsrc.me/rcp/$source", [
            'headers' => [
                'Referer' => $url
            ]
        ]);
        $req_1_text = $req_1->getBody()->getContents();
        $crawler2 = new Crawler($req_1_text);
        $encoded = $crawler2->filter('div#hidden')->attr('data-h');

        $seed = $crawler->filter('body')->attr('data-i');


        $decoded_url = $this->decode_src($encoded, $seed);
        if (strpos($decoded_url, "//") === 0) {
            $decoded_url = "https:" . $decoded_url;
        }
        $req_2 = $client->get($decoded_url, [
            'allow_redirects' => false,
            'headers' => [
                'Referer' => $url
            ]
        ]);
        $location = $req_2->getHeaderLine("Location");

       
        if (strpos($location, "vidsrc.stream") !== false) {
            return $this->handle_vidsrc_stream($location, "https://rcp.vidsrc.me/rcp/$source");
        }
        if (strpos($location, "2embed.cc") !== false) {
            echo "[Warning] 2Embed does not work, this will not return anything!\n";
            return $this->handle_2embed($location, "https://rcp.vidsrc.me/rcp/$source");
        }
        if (strpos($location, "multiembed.mov") !== false) {
            return $this->handle_multiembed($location, "https://rcp.vidsrc.me/rcp/$source");
        }
    }

    public function vidsrc ($id){


        $vse = new VidSrcExtractorController();

       
        if($id !=null){

            $dUrl = $vse->get_vidsrc_stream("Superembed", "movie", $id, "eng");
            $data = ['status' => 200, 'url' => $dUrl,];

        }else {

            $data = ['status' => 400, 'url' => "error",];

        }


   

        return response()->json($data, 200);
    }
    


    public function getStreamSb($url) {

        $client = new Client(['verify' => false]);
        $req = $client->get($url);
        $req_text = $req->getBody()->getContents();
        $crawler = new Crawler($req_text);
        dd($crawler);
      
    }

    public function streamsb (){

        $vse = new VidSrcExtractorController();

        $dUrl = $vse->getStreamSb("https://netfilm.app/watch/movie/634492");

        return response()->json($data, 200);
    }
}

?>
