<?php

namespace App\Http\Middleware;
use Jenssegers\Agent\Agent;
use Closure;
use Illuminate\Support\Str;
use App\Setting;
use Illuminate\Support\Facades\Hash;



class Decrypter extends Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string[]  ...$guards
     * @return mixed
     *
     * @throws \Illuminate\Auth\AuthenticationException
     */
     
    
     public function handle($request, Closure $next, ...$guards)
     {


        $arrayValues = json_decode(env('SIGNATURE'), true);


        $signature = $request->header('signature');
         $package = $request->header('packagename');
         $password = $request->header('password');
         $token = $request->bearerToken();
         $agent = new Agent();
         $settings = Setting::first();
     
         // Split the package name into parts using dot as a separator
         $packageNameParts = explode('.', $package);


         if(env('ENABLE_API_CHECK')){

         // Check if the first part of the package name matches your desired value
         if ($package == env('PACKAGE_NAME') && in_array($signature, $arrayValues) && $agent->isAndroidOS()) {
             return $next($request);
         } else {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

         }else {

            return $next($request);

         }
     
     
     }
}
