<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;
use App\Http\ClearsResponseCache;
use BeyondCode\Comments\Traits\HasComments;
use Illuminate\Support\Facades\DB;

class Serie extends Model
{


    use Favoriteable,ClearsResponseCache,HasComments;

    protected $fillable = ['tmdb_id', 'name', 'overview', 'poster_path', 'backdrop_path','backdrop_path_tv', 'preview_path', 'vote_average',
     'vote_count', 'popularity','featured', 'premuim','active','views', 'first_air_date', 'tv','pinned','newEpisodes','imdb_external_id','original_name'
    ,'trailer_url','subtitle','rating'];

    protected $with = ['casters.cast','genres.genre', 'seasons','networks.network','spoken_languages'];

    protected $appends = ['genreslist','casterslist','networkslist','genresname','relateds'];

    protected $casts = [
        'status' => 'int',
        'premuim' => 'int',
        'active' => 'int',
        'featured' => 'int',
        'pinned' => 'int',
        'newEpisodes' => 'int'

    ];



    public function casters()
    {
        return $this->hasMany('App\SerieCast');
    }



    public function networks()
    {
        return $this->hasMany('App\SerieNetwork');
    }


    public function genres()
    {
        return $this->hasMany('App\SerieGenre');
    }

    public function seasons()
    {

        return $this->hasMany('App\Season');
    }


    public function spoken_languages()
    {
        return $this->hasMany('App\SerieSpokenLanguage');
    }


    public function getCasterslistAttribute()
    {
        $casters = [];
        foreach ($this->casters as $caster) {
            array_push($casters, $caster->cast);
        }
        return $casters;
    }

    public function getNetworkslistAttribute()
    {
        $networks = [];
        foreach ($this->networks as $network) {
            array_push($networks, $network->network);
        }
        return $networks;
    }



    public function getGenreslistAttribute()
    {
        $genres = [];
        foreach ($this->genres as $genre) {
            array_push($genres, $genre['name']);
        }
    return $genres;
    }


    public function getGenresNameAttribute()
    {
        $genres = "";
        foreach ($this->genres as $genre) {
            return $genre['name'];
        }

    }


    public function relatedSeries()
    {
        $selectSerie = [
            'series.id', 'name', 'poster_path', 'backdrop_path',
            'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
            'pinned', 'series.created_at', 'series.updated_at', 'views', DB::raw("'serie' AS type"), "newEpisodes"
        ];

        $moviesGenre = $this->withOnly('genres.genre')
            ->where('id', $this->id)
            ->select(['series.id', 'series.name', 'series.poster_path', 'series.vote_average', 'series.newEpisodes', 'series.subtitle'])
            ->where('active', 1)
            ->limit(1)
            ->orderByDesc('series.created_at')
            ->get();

        $relatedMovies = [];

        foreach ($moviesGenre as $serie) {
            $genre = $serie->genres[0]->genre_id;

            $relatedMoviesQuery = DB::table('series')
                ->join('serie_genres', 'series.id', '=', 'serie_genres.serie_id')
                ->where('serie_genres.genre_id', $genre)
                ->where('serie_genres.serie_id', '!=', $this->id)
                ->select($selectSerie)
                ->where('active', 1)
                ->limit(10)
                ->orderByDesc('series.created_at')
                ->get();

            $relatedMovies = $relatedMoviesQuery->toArray();
        }

        return $relatedMovies;
    }


    public function getRelatedsAttribute()
    {
        // Implement logic to retrieve related movies
        // Example:
        return $this->relatedSeries();
    }

}
