<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateResumesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resumes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_resume_id');
            $table->string('tmdb')->nullable();
            $table->integer('resumeWindow')->nullable();
            $table->integer('resumePosition')->nullable();
            $table->integer('movieDuration')->nullable();
            $table->integer('deviceId')->nullable();
            $table->integer('profileId')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resumes');
    }
}
