<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDataplex;

class GoogleCloudDataplexV1DataScanJob extends \Google\Model
{
  protected $dataDocumentationResultType = GoogleCloudDataplexV1DataDocumentationResult::class;
  protected $dataDocumentationResultDataType = '';
  protected $dataDocumentationSpecType = GoogleCloudDataplexV1DataDocumentationSpec::class;
  protected $dataDocumentationSpecDataType = '';
  protected $dataProfileResultType = GoogleCloudDataplexV1DataProfileResult::class;
  protected $dataProfileResultDataType = '';
  protected $dataProfileSpecType = GoogleCloudDataplexV1DataProfileSpec::class;
  protected $dataProfileSpecDataType = '';
  protected $dataQualityResultType = GoogleCloudDataplexV1DataQualityResult::class;
  protected $dataQualityResultDataType = '';
  protected $dataQualitySpecType = GoogleCloudDataplexV1DataQualitySpec::class;
  protected $dataQualitySpecDataType = '';
  /**
   * @var string
   */
  public $endTime;
  /**
   * @var string
   */
  public $message;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $startTime;
  /**
   * @var string
   */
  public $state;
  /**
   * @var string
   */
  public $type;
  /**
   * @var string
   */
  public $uid;

  /**
   * @param GoogleCloudDataplexV1DataDocumentationResult
   */
  public function setDataDocumentationResult(GoogleCloudDataplexV1DataDocumentationResult $dataDocumentationResult)
  {
    $this->dataDocumentationResult = $dataDocumentationResult;
  }
  /**
   * @return GoogleCloudDataplexV1DataDocumentationResult
   */
  public function getDataDocumentationResult()
  {
    return $this->dataDocumentationResult;
  }
  /**
   * @param GoogleCloudDataplexV1DataDocumentationSpec
   */
  public function setDataDocumentationSpec(GoogleCloudDataplexV1DataDocumentationSpec $dataDocumentationSpec)
  {
    $this->dataDocumentationSpec = $dataDocumentationSpec;
  }
  /**
   * @return GoogleCloudDataplexV1DataDocumentationSpec
   */
  public function getDataDocumentationSpec()
  {
    return $this->dataDocumentationSpec;
  }
  /**
   * @param GoogleCloudDataplexV1DataProfileResult
   */
  public function setDataProfileResult(GoogleCloudDataplexV1DataProfileResult $dataProfileResult)
  {
    $this->dataProfileResult = $dataProfileResult;
  }
  /**
   * @return GoogleCloudDataplexV1DataProfileResult
   */
  public function getDataProfileResult()
  {
    return $this->dataProfileResult;
  }
  /**
   * @param GoogleCloudDataplexV1DataProfileSpec
   */
  public function setDataProfileSpec(GoogleCloudDataplexV1DataProfileSpec $dataProfileSpec)
  {
    $this->dataProfileSpec = $dataProfileSpec;
  }
  /**
   * @return GoogleCloudDataplexV1DataProfileSpec
   */
  public function getDataProfileSpec()
  {
    return $this->dataProfileSpec;
  }
  /**
   * @param GoogleCloudDataplexV1DataQualityResult
   */
  public function setDataQualityResult(GoogleCloudDataplexV1DataQualityResult $dataQualityResult)
  {
    $this->dataQualityResult = $dataQualityResult;
  }
  /**
   * @return GoogleCloudDataplexV1DataQualityResult
   */
  public function getDataQualityResult()
  {
    return $this->dataQualityResult;
  }
  /**
   * @param GoogleCloudDataplexV1DataQualitySpec
   */
  public function setDataQualitySpec(GoogleCloudDataplexV1DataQualitySpec $dataQualitySpec)
  {
    $this->dataQualitySpec = $dataQualitySpec;
  }
  /**
   * @return GoogleCloudDataplexV1DataQualitySpec
   */
  public function getDataQualitySpec()
  {
    return $this->dataQualitySpec;
  }
  /**
   * @param string
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * @param string
   */
  public function setMessage($message)
  {
    $this->message = $message;
  }
  /**
   * @return string
   */
  public function getMessage()
  {
    return $this->message;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param string
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDataplexV1DataScanJob::class, 'Google_Service_CloudDataplex_GoogleCloudDataplexV1DataScanJob');
